<?php 
/**
 * Template part for displaying Featured Classes Section
 *
 * @package Prime English Classes
 */

$prime_english_classes_about = get_theme_mod( 'prime_english_classes_about_setting',false );
$prime_english_classes_featured_mission_section_title = get_theme_mod( 'prime_english_classes_featured_mission_section_title' );
$prime_english_classes_featured_mission_posts[] = get_theme_mod( 'prime_english_classes_featured_mission_post_' );

?>
<?php if ( $prime_english_classes_about ){?>
<div id="about-section" class="section-content py-5">
    <div class="container">        
        <?php $args = array (
            'post_type'     => 'page',
            'posts_per_page' => 1,
            'post__in'      => $prime_english_classes_featured_mission_posts,
            'orderby'       =>'post__in',
            'ignore_sticky_posts' => true,
        );?>
        <?php
        $loop = new WP_Query($args);
        if ( $loop->have_posts() ) :
            while ($loop->have_posts()) : $loop->the_post(); ?>
            <div class="featured-mission-box">
                <div class="row">
                    <div class="col-lg-6 col-md-12 align-self-center about-us position-relative">
                        <div class="about-img">
                           <?php
                              if ( has_post_thumbnail() ) :
                                the_post_thumbnail();
                              else:
                                ?>
                                <div class="image-container">
                                  <img src="<?php echo get_stylesheet_directory_uri() . '/images/default-header.png'; ?>">
                                </div>
                                <?php
                              endif;
                            ?>
                        </div>
                       <div class="image-1">
                            <img class="img-1-border" src="<?php echo esc_url(get_theme_mod('prime_english_classes_about_us_img_1')); ?>">
                        </div>
                        <div class="image-2">
                            <img class="img-2-border" src="<?php echo esc_url(get_theme_mod('prime_english_classes_about_us_img_2')); ?>">
                        </div>  
                    </div> 

                    <div class="col-lg-6 col-md-12 align-self-center side-1 position-relative">
                        <div class="entry-header">
                             <?php if ( get_theme_mod('prime_english_classes_about_text_extra') ) : ?>
                                <h5><i class="fas fa-graduation-cap"></i><?php echo esc_html(get_theme_mod('prime_english_classes_about_text_extra'));?></h5>
                              <?php endif; ?>
                            <?php if( !empty($prime_english_classes_featured_mission_section_title) ): ?>
                                <div class="section-title">
                                    <h3><?php echo esc_html($prime_english_classes_featured_mission_section_title); ?></h3>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="entry-content">
                            <p class="mb-0 about-para"><?php echo wp_trim_words( get_the_content(), 40 ); ?></p>
                        </div>
                        <?php $prime_english_classes_about_point = get_theme_mod('prime_english_classes_about_points','');
                          for ( $prime_english_classes_m = 1; $prime_english_classes_m <= $prime_english_classes_about_point; $prime_english_classes_m++ ){ ?>
                            <p class="list"><i class="fas fa-check me-2"></i><?php echo esc_html(get_theme_mod('prime_english_classes_about_points_text'.$prime_english_classes_m,'')); ?></p>
                        <?php } ?>
                        <div class="btn-green my-4">
                            <a href="<?php the_permalink(); ?>">
                            <?php esc_html_e('About More','prime-english-classes'); ?>
                            </a>
                        </div>  
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
    </div>
</div>
<?php } ?>