<?php
/**
 * Banner Section
 * 
 * @package prime_english_classes
 */
$prime_english_classes_slider_background_image = get_theme_mod( 'prime_english_classes_slider_background_image');

$prime_english_classes_slider = get_theme_mod( 'prime_english_classes_slider_setting',false );
$prime_english_classes_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('prime_english_classes_blog_slide_category'),
  'posts_per_page' => 3,
); ?>

<?php if ( $prime_english_classes_slider ){?>
<div class="slider-back">
  <div class="banner" style="background: url(<?php if ( !empty($prime_english_classes_slider_background_image) ) { echo esc_url( $prime_english_classes_slider_background_image ); } else { 
             echo get_stylesheet_directory_uri() . '/images/slide.png'; } ?>); background-size: 100% 100%; background-repeat: no-repeat; background-color: #000;">
    <div class="banner-main">
      <div class="owl-carousel">
        <?php $prime_english_classes_arr_posts = new WP_Query( $prime_english_classes_args );
        if ( $prime_english_classes_arr_posts->have_posts() ) :
          while ( $prime_english_classes_arr_posts->have_posts() ) :
            $prime_english_classes_arr_posts->the_post();
            ?>
            <div class="banner_inner_box">
              <div class="container">
                <div class="row">
                <div class="col-lg-7 col-md-12 col-12 align-self-center">
                  <div class="banner_box">
                    <?php if ( get_theme_mod('prime_english_classes_slider_text_extra') ) : ?>
                      <h5><?php echo esc_html(get_theme_mod('prime_english_classes_slider_text_extra'));?></h5>
                    <?php endif; ?>
                    <h3 class="my-3"><?php the_title(); ?></a></h3>
                     <p class="mb-0 slide-para"><?php echo wp_trim_words( get_the_content(), 30 ); ?></p>
                    <div class="slide-btns">
                      <p class="btn-green mt-4">
                      <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Get started','prime-english-classes'); ?></a>
                    </p>
                    </div>
                  </div>
                </div>
                <div class="col-lg-5 col-md-12 col-12 align-self-center banner_inner_box_img">
                  <?php
                    if ( has_post_thumbnail() ) :
                      the_post_thumbnail();
                    else:
                      ?>
                      <div class="banner_inner_box_img">
                        <img src="<?php echo get_stylesheet_directory_uri() . '/images/default-header.png'; ?>">
                      </div>
                      <?php
                    endif;
                  ?>
                </div>
              </div>
              </div>
            </div>
          <?php
        endwhile;
        wp_reset_postdata();
        endif; ?>
      </div>
    </div>
  </div>
</div>
<?php } ?>