<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package prime_english_classes
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function prime_english_classes_body_classes( $classes ) {
  global $prime_english_classes_post;
  
    if( !is_page_template( 'template-home.php' ) ){
        $classes[] = 'inner';
        // Adds a class of group-blog to blogs with more than 1 published author.
    }

    if ( is_multi_author() ) {
        $classes[] = 'group-blog ';
    }

    // Adds a class of custom-background-image to sites with a custom background image.
    if ( get_background_image() ) {
        $classes[] = 'custom-background-image';
    }
    
    // Adds a class of custom-background-color to sites with a custom background color.
    if ( get_background_color() != 'ffffff' ) {
        $classes[] = 'custom-background-color';
    }
    

    if( prime_english_classes_woocommerce_activated() && ( is_shop() || is_product_category() || is_product_tag() || 'product' === get_post_type() ) && ! is_active_sidebar( 'shop-sidebar' ) ){
        $classes[] = 'full-width';
    }    

    // Adds a class of hfeed to non-singular pages.
    if ( ! is_page() ) {
        $classes[] = 'hfeed ';
    }
  
    if( is_404() ||  is_search() ){
        $classes[] = 'full-width';
    }
  
    if( ! is_active_sidebar( 'right-sidebar' ) ) {
        $classes[] = 'full-width'; 
    }

    return $classes;
}
add_filter( 'body_class', 'prime_english_classes_body_classes' );

 /**
 * 
 * @link http://www.altafweb.com/2011/12/remove-specific-tag-from-php-string.html
 */
function prime_english_classes_strip_single( $tag, $string ){
    $string=preg_replace('/<'.$tag.'[^>]*>/i', '', $string);
    $string=preg_replace('/<\/'.$tag.'>/i', '', $string);
    return $string;
}

if ( ! function_exists( 'prime_english_classes_excerpt_more' ) ) :
/**
 * Replaces "[...]" (appended to automatically generated excerpts) with ... * 
 */
function prime_english_classes_excerpt_more($more) {
  return is_admin() ? $more : ' &hellip; ';
}
endif;
add_filter( 'excerpt_more', 'prime_english_classes_excerpt_more' );


if( ! function_exists( 'prime_english_classes_footer_credit' ) ):
/**
 * Footer Credits
*/
function prime_english_classes_footer_credit() {
    $prime_english_classes_copyright_text = get_theme_mod('prime_english_classes_footer_copyright_text');

    $prime_english_classes_text = '<div class="site-info"><div class="container"><span class="copyright">';
    if ($prime_english_classes_copyright_text) {
        $prime_english_classes_text .= wp_kses_post($prime_english_classes_copyright_text); 
    } else {
        $prime_english_classes_text .= esc_html__('&copy; ', 'prime-english-classes') . date_i18n(esc_html__('Y', 'prime-english-classes')); 
        $prime_english_classes_text .= ' <a href="' . esc_url(home_url('/')) . '">' . esc_html(get_bloginfo('name')) . '</a>' . esc_html__('. All Rights Reserved.', 'prime-english-classes');
    }
     $prime_english_classes_text .= '</span>';
       $prime_english_classes_text .= '<span class="by"> '.PRIME_ENGLISH_CLASSES_THEME_NAME . ' '. esc_html__( 'By ', 'prime-english-classes' ) . '<a href="' . esc_url( 'https://themeignite.com/' ) .'" rel="nofollow" target="_blank">' . esc_html__( 'Themeignite', 'prime-english-classes' ) . '</a>.';
        $prime_english_classes_text .= sprintf( esc_html__( ' Powered By %s', 'prime-english-classes' ), '<a href="'. esc_url( __( 'https://wordpress.org/', 'prime-english-classes' ) ) .'" target="_blank">WordPress</a>.' );
        if ( function_exists( 'the_privacy_policy_link' ) ) {
            $prime_english_classes_text .= get_the_privacy_policy_link();
        }
        $prime_english_classes_text .= '</span></div></div>';
    echo apply_filters('prime_english_classes_footer_text', $prime_english_classes_text);
}
add_action('prime_english_classes_footer', 'prime_english_classes_footer_credit');
endif;

/**
 * Is Woocommerce activated
*/
if ( ! function_exists( 'prime_english_classes_woocommerce_activated' ) ) {
  function prime_english_classes_woocommerce_activated() {
    if ( class_exists( 'woocommerce' ) ) { return true; } else { return false; }
  }
}

if( ! function_exists( 'prime_english_classes_change_comment_form_default_fields' ) ) :
/**
 * Change Comment form default fields i.e. author, email & url.
 * https://blog.josemcastaneda.com/2016/08/08/copy-paste-hurting-theme/
*/
function prime_english_classes_change_comment_form_default_fields( $fields ){    
    // get the current commenter if available
    $prime_english_classes_commenter = wp_get_current_commenter();
 
    // core functionality
    $req      = get_option( 'require_name_email' );
    $prime_english_classes_aria_req = ( $req ? " aria-required='true'" : '' );
    $prime_english_classes_required = ( $req ? " required" : '' );
    $prime_english_classes_author   = ( $req ? __( 'Name*', 'prime-english-classes' ) : __( 'Name', 'prime-english-classes' ) );
    $prime_english_classes_email    = ( $req ? __( 'Email*', 'prime-english-classes' ) : __( 'Email', 'prime-english-classes' ) );
 
    // Change just the author field
    $fields['author'] = '<p class="comment-form-author"><label class="screen-reader-text" for="author">' . esc_html__( 'Name', 'prime-english-classes' ) . '<span class="required">*</span></label><input id="author" name="author" placeholder="' . esc_attr( $prime_english_classes_author ) . '" type="text" value="' . esc_attr( $prime_english_classes_commenter['comment_author'] ) . '" size="30"' . $prime_english_classes_aria_req . $prime_english_classes_required . ' /></p>';
    
    $fields['email'] = '<p class="comment-form-email"><label class="screen-reader-text" for="email">' . esc_html__( 'Email', 'prime-english-classes' ) . '<span class="required">*</span></label><input id="email" name="email" placeholder="' . esc_attr( $prime_english_classes_email ) . '" type="text" value="' . esc_attr(  $prime_english_classes_commenter['comment_author_email'] ) . '" size="30"' . $prime_english_classes_aria_req . $prime_english_classes_required. ' /></p>';
    
    $fields['url'] = '<p class="comment-form-url"><label class="screen-reader-text" for="url">' . esc_html__( 'Website', 'prime-english-classes' ) . '</label><input id="url" name="url" placeholder="' . esc_attr__( 'Website', 'prime-english-classes' ) . '" type="text" value="' . esc_attr( $prime_english_classes_commenter['comment_author_url'] ) . '" size="30" /></p>'; 
    
    return $fields;    
}
endif;
add_filter( 'comment_form_default_fields', 'prime_english_classes_change_comment_form_default_fields' );

if( ! function_exists( 'prime_english_classes_change_comment_form_defaults' ) ) :
/**
 * Change Comment Form defaults
 * https://blog.josemcastaneda.com/2016/08/08/copy-paste-hurting-theme/
*/
function prime_english_classes_change_comment_form_defaults( $defaults ){    
    $defaults['comment_field'] = '<p class="comment-form-comment"><label class="screen-reader-text" for="comment">' . esc_html__( 'Comment', 'prime-english-classes' ) . '</label><textarea id="comment" name="comment" placeholder="' . esc_attr__( 'Comment', 'prime-english-classes' ) . '" cols="45" rows="8" aria-required="true" required></textarea></p>';
    
    return $defaults;    
}
endif;
add_filter( 'comment_form_defaults', 'prime_english_classes_change_comment_form_defaults' );

if( ! function_exists( 'prime_english_classes_escape_text_tags' ) ) :
/**
 * Remove new line tags from string
 *
 * @param $text
 * @return string
 */
function prime_english_classes_escape_text_tags( $text ) {
    return (string) str_replace( array( "\r", "\n" ), '', strip_tags( $text ) );
}
endif;

if( ! function_exists( 'wp_body_open' ) ) :
/**
 * Fire the wp_body_open action.
 * Added for backwards compatibility to support pre 5.2.0 WordPress versions.
*/
function wp_body_open() {
    /**
     * Triggered after the opening <body> tag.
    */
    do_action( 'wp_body_open' );
}
endif;

if ( ! function_exists( 'prime_english_classes_get_fallback_svg' ) ) :    
/**
 * Get Fallback SVG
*/
function prime_english_classes_get_fallback_svg( $prime_english_classes_post_thumbnail ) {
    if( ! $prime_english_classes_post_thumbnail ){
        return;
    }
    
    $prime_english_classes_image_size = prime_english_classes_get_image_sizes( $prime_english_classes_post_thumbnail );
     
    if( $prime_english_classes_image_size ){ ?>
        <div class="svg-holder">
             <svg class="fallback-svg" viewBox="0 0 <?php echo esc_attr( $prime_english_classes_image_size['width'] ); ?> <?php echo esc_attr( $prime_english_classes_image_size['height'] ); ?>" preserveAspectRatio="none">
                    <rect width="<?php echo esc_attr( $prime_english_classes_image_size['width'] ); ?>" height="<?php echo esc_attr( $prime_english_classes_image_size['height'] ); ?>" style="fill:#dedddd;"></rect>
            </svg>
        </div>
        <?php
    }
}
endif;

function prime_english_classes_enqueue_google_fonts() {

    require get_template_directory() . '/inc/wptt-webfont-loader.php';

    wp_enqueue_style(
        'google-fonts-jost',
        wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Jost:ital,wght@0,100..900;1,100..900&display=swap' ),
        array(),
        '1.0'
    );
}
add_action( 'wp_enqueue_scripts', 'prime_english_classes_enqueue_google_fonts' );


if( ! function_exists( 'prime_english_classes_site_branding' ) ) :
/**
 * Site Branding
*/
function prime_english_classes_site_branding(){
    $prime_english_classes_logo_site_title = get_theme_mod( 'header_site_title', 1 );
    $prime_english_classes_tagline = get_theme_mod( 'header_tagline', false );
    $prime_english_classes_logo_width = get_theme_mod('logo_width', 100); // Retrieve the logo width setting

    ?>
    <div class="site-branding" style="max-width: <?php echo esc_attr(get_theme_mod('logo_width', '-1'))?>px;">
        <?php 
        // Check if custom logo is set and display it
        if (function_exists('has_custom_logo') && has_custom_logo()) {
            the_custom_logo();
        }
        if ($prime_english_classes_logo_site_title):
             if (is_front_page()): ?>
            <h1 class="site-title" style="font-size: <?php echo esc_attr(get_theme_mod('prime_english_classes_site_title_size', '30')); ?>px;">
            <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
          </h1>
            <?php else: ?>
                <p class="site-title" itemprop="name">
                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                </p>
            <?php endif; ?>
        <?php endif; 
    
        if ($prime_english_classes_tagline) :
            $prime_english_classes_description = get_bloginfo('description', 'display');
            if ($prime_english_classes_description || is_customize_preview()) :
        ?>
                <p class="site-description" itemprop="description"><?php echo $prime_english_classes_description; ?></p>
            <?php endif;
        endif;
        ?>
    </div>
    <?php
}
endif;
if( ! function_exists( 'prime_english_classes_navigation' ) ) :
    /**
     * Site Navigation
    */
    function prime_english_classes_navigation(){
        ?>
        <nav class="main-navigation" id="site-navigation" role="navigation">
            <?php 
            wp_nav_menu( array( 
                'theme_location' => 'primary', 
                'menu_id' => 'primary-menu' 
            ) ); 
            ?>
        </nav>
        <?php
    }
endif;

if( ! function_exists( 'prime_english_classes_header' ) ) :
    /**
     * Header Start
    */
    function prime_english_classes_header(){
        $prime_english_classes_header_image = get_header_image();
        $prime_english_classes_header_btn_text     = get_theme_mod( 'prime_english_classes_header_btn_text' );
        $prime_english_classes_header_btn_url     = get_theme_mod( 'prime_english_classes_header_btn_url' );
        $prime_english_classes_phone        = get_theme_mod( 'prime_english_classes_header_phone' );
        $prime_english_classes_social_icon = get_theme_mod( 'prime_english_classes_social_icon_setting', false);
        $prime_english_classes_header_setting     = get_theme_mod( 'prime_english_classes_header_setting', false );
        $prime_english_classes_phone        = get_theme_mod( 'prime_english_classes_header_phone' );
        $prime_english_classes_email        = get_theme_mod( 'prime_english_classes_header_email' );
        ?>
        <div id="page-site-header" class="main-header">
    <header id="masthead">
        <div class="topbar">
            <div class="container">
                <div class="row py-2 top-head">
                    <div class="col-xl-2 col-lg-0"></div>
                    <div class="col-xl-7 col-lg-9 col-md-6 align-self-center text-md-start mail-phone">
                        <?php if ( $prime_english_classes_email ) { ?>
                            <div class="location">
                                <span class="contact-icon">
                                    <i class="fa-solid fa-envelope"></i>
                                </span>
                                <span class="contact-box">
                                    <span class="location-text">
                                        <a href="mailto:<?php echo esc_attr($prime_english_classes_email); ?>">
                                            <?php echo esc_html($prime_english_classes_email); ?>
                                        </a>
                                    </span>
                                </span>
                            </div>
                        <?php } ?>

                        <?php if ( $prime_english_classes_phone ) { ?>
                            <div class="location">
                                <span class="contact-icon">
                                    <i class="fas fa-phone-alt"></i>
                                </span>
                                <span class="contact-box">
                                    <span class="location-text">
                                        <a href="tel:<?php echo esc_attr($prime_english_classes_phone); ?>">
                                            <?php echo esc_html($prime_english_classes_phone); ?>
                                        </a>
                                    </span>
                                </span>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 align-self-center header-detail text-md-end">
                        <?php if ( $prime_english_classes_social_icon ) { ?>
                            <div class="social-links">
                                <?php 
                                $prime_english_classes_social_link1 = get_theme_mod( 'prime_english_classes_social_link_1' );
                                $prime_english_classes_social_link2 = get_theme_mod( 'prime_english_classes_social_link_2' );
                                $prime_english_classes_social_link3 = get_theme_mod( 'prime_english_classes_social_link_3' );
                                $prime_english_classes_social_link4 = get_theme_mod( 'prime_english_classes_social_link_4' );

                                if ( ! empty( $prime_english_classes_social_link1 ) ) {
                                    echo '<a class="social1" href="' . esc_url( $prime_english_classes_social_link1 ) . '" target="_blank"><i class="fab fa-facebook-f"></i></a>';
                                }
                                if ( ! empty( $prime_english_classes_social_link2 ) ) {
                                    echo '<a class="social2" href="' . esc_url( $prime_english_classes_social_link2 ) . '" target="_blank"><i class="fab fa-twitter"></i></a>';
                                } 
                                if ( ! empty( $prime_english_classes_social_link3 ) ) {
                                    echo '<a class="social3" href="' . esc_url( $prime_english_classes_social_link3 ) . '" target="_blank"><i class="fab fa-instagram"></i></a>';
                                }
                                if ( ! empty( $prime_english_classes_social_link4 ) ) {
                                    echo '<a class="social4" href="' . esc_url( $prime_english_classes_social_link4 ) . '" target="_blank"><i class="fab fa-pinterest-p"></i></a>';
                                }
                                ?>
                            </div>
                        <?php } ?>  
                    </div>
                </div>
            </div>
        </div>
        <div class="mid-head">
            <div class="row m-0">
                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 align-self-center position-relative logo-div">
                    <?php prime_english_classes_site_branding(); ?>
                </div>
                <div class="col-xl-9 col-lg-9 col-md-9 col-sm-12 align-self-center theme-menu-bg site-header-img"  style="background-image: url('<?php echo esc_url( $prime_english_classes_header_image ); ?>');" role="banner">
                    <div class="row m-0">
                        <div class="col-xl-8 col-lg-8 col-md-3 align-self-center">
                            <?php prime_english_classes_navigation(); ?> 
                        </div>
                        <div class="col-xl-1 col-lg-1 col-md-3 col-6 align-self-center position-relative">
                            <?php if( get_theme_mod('prime_english_classes_show_hide_search', false) ) { ?>
                                <div class="search-body">
                                    <button type="button" class="search-show">
                                        <i class="<?php echo esc_attr(get_theme_mod('prime_english_classes_search_icon', 'fas fa-search')); ?>"></i>
                                    </button>
                                </div>
                                <div class="searchform-inner">
                                    <?php get_search_form(); ?>
                                    <button 
                                        type="button" 
                                        class="close" 
                                        aria-label="<?php esc_attr_e( 'Close', 'prime-english-classes' ); ?>"
                                    >
                                        <span aria-hidden="true">X</span>
                                    </button>
                                </div> 
                            <?php } ?> 
                        </div> 
                        <div class="col-xl-3 col-lg-3 col-md-6 col-6 align-self-center btn_bg">
                            <?php if ( $prime_english_classes_header_btn_text ) { ?>
                                <div class="menudiv-button">
                                    <a href="<?php echo esc_url($prime_english_classes_header_btn_url); ?>">
                                        <?php echo esc_html($prime_english_classes_header_btn_text); ?>
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div> 
                </div>
            </div>
        </div>
    </header>
</div>

        <?php
    }
endif;
add_action( 'prime_english_classes_header', 'prime_english_classes_header', 20 );
