<?php
/**
 * Prime English Classes Theme Customizer.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package prime_english_classes
 */

if( ! function_exists( 'prime_english_classes_customize_register' ) ):  
/**
 * Add postMessage support for site title and description for the Theme Customizer.F
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function prime_english_classes_customize_register( $wp_customize ) {
    require get_parent_theme_file_path('/inc/controls/changeable-icon.php');
    

    if ( version_compare( get_bloginfo('version'),'4.9', '>=') ) {
        $wp_customize->get_section( 'static_front_page' )->title = __( 'Static Front Page', 'prime-english-classes' );
    }
	
    /* Option list of all post */	
    $prime_english_classes_options_posts = array();
    $prime_english_classes_options_posts_obj = get_posts('posts_per_page=-1');
    $prime_english_classes_options_posts[''] = esc_html__( 'Choose Post', 'prime-english-classes' );
    foreach ( $prime_english_classes_options_posts_obj as $prime_english_classes_posts ) {
    	$prime_english_classes_options_posts[$prime_english_classes_posts->ID] = $prime_english_classes_posts->post_title;
    }
    
    /* Option list of all categories */
    $prime_english_classes_args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'order'                    => 'ASC',
	   'hide_empty'               => 1,
	   'hierarchical'             => 1,
	   'taxonomy'                 => 'category'
    ); 
    $prime_english_classes_option_categories = array();
    $prime_english_classes_category_lists = get_categories( $prime_english_classes_args );
    $prime_english_classes_option_categories[''] = esc_html__( 'Choose Category', 'prime-english-classes' );
    foreach( $prime_english_classes_category_lists as $prime_english_classes_category ){
        $prime_english_classes_option_categories[$prime_english_classes_category->term_id] = $prime_english_classes_category->name;
    }
    
    /** Default Settings */    
    $wp_customize->add_panel( 
        'wp_default_panel',
         array(
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__( 'Default Settings', 'prime-english-classes' ),
            'description' => esc_html__( 'Default section provided by wordpress customizer.', 'prime-english-classes' ),
        ) 
    );
    
    $wp_customize->get_section( 'title_tagline' )->panel                  = 'wp_default_panel';
    $wp_customize->get_section( 'colors' )->panel                         = 'wp_default_panel';
    $wp_customize->get_section( 'header_image' )->panel                   = 'wp_default_panel';
    $wp_customize->get_section( 'background_image' )->panel               = 'wp_default_panel';
    $wp_customize->get_section( 'static_front_page' )->panel              = 'wp_default_panel';
    
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    
    /** Default Settings Ends */
    
    /** Site Title control */
    $wp_customize->add_setting( 
        'header_site_title', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_site_title',
        array(
            'label'       => __( 'Show / Hide Site Title', 'prime-english-classes' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    /** Tagline control */
    $wp_customize->add_setting( 
        'header_tagline', 
        array(
            'default'           => false,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_tagline',
        array(
            'label'       => __( 'Show / Hide Tagline', 'prime-english-classes' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('logo_width', array(
        'sanitize_callback' => 'absint', 
    ));

    // Add a control for logo width
    $wp_customize->add_control('logo_width', array(
        'label' => __('Logo Width', 'prime-english-classes'),
        'section' => 'title_tagline',
        'type' => 'number',
        'input_attrs' => array(
            'min' => '50', 
            'max' => '500', 
            'step' => '5', 
    ),
        'default' => '100', 
    ));

    $wp_customize->add_setting( 'prime_english_classes_site_title_size', array(
        'default'           => 30, // Default font size in pixels
        'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
    ) );

    // Add control for site title size
    $wp_customize->add_control( 'prime_english_classes_site_title_size', array(
        'type'        => 'number',
        'section'     => 'title_tagline', // You can change this section to your preferred section
        'label'       => __( 'Site Title Font Size (px)', 'prime-english-classes' ),
        'input_attrs' => array(
            'min'  => 10,
            'max'  => 100,
            'step' => 1,
        ),
    ) );
    /** Post Settings */
    $wp_customize->add_section(
        'prime_english_classes_post_settings',
        array(
            'title' => esc_html__( 'Post Settings', 'prime-english-classes' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
        )
    );

    /** Post Heading control */
    $wp_customize->add_setting( 
        'prime_english_classes_post_heading_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_post_heading_setting',
        array(
            'label'       => __( 'Show / Hide Post Heading', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Meta control */
    $wp_customize->add_setting( 
        'prime_english_classes_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Post Meta', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Image control */
    $wp_customize->add_setting( 
        'prime_english_classes_post_image_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_post_image_setting',
        array(
            'label'       => __( 'Show / Hide Post Image', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Content control */
    $wp_customize->add_setting( 
        'prime_english_classes_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Post Content', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_post_settings',
            'type'        => 'checkbox',
        )
    );
    /** Post ReadMore control */
     $wp_customize->add_setting( 'prime_english_classes_read_more_setting`', array(
        'default'           => true,
        'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
    ) );

    $wp_customize->add_control( 'prime_english_classes_read_more_setting`', array(
        'type'        => 'checkbox',
        'section'     => 'prime_english_classes_post_settings', 
        'label'       => __( 'Display Read More Button', 'prime-english-classes' ),
    ) );

    /** Post Settings Ends */

     /** Single Post Settings */
    $wp_customize->add_section(
        'prime_english_classes_single_post_settings',
        array(
            'title' => esc_html__( 'Single Post Settings', 'prime-english-classes' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
        )
    );

    /** Single Post Meta control */
    $wp_customize->add_setting( 
        'prime_english_classes_single_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_single_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Meta', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Content control */
    $wp_customize->add_setting( 
        'prime_english_classes_single_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_single_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Content', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Settings Ends */

         // Typography Settings Section
    $wp_customize->add_section('prime_english_classes_typography_settings', array(
        'title'      => esc_html__('Typography Settings', 'prime-english-classes'),
        'priority'   => 30,
        'capability' => 'edit_theme_options',
    ));

    // Array of fonts to choose from
    $font_choices = array(
        ''               => __('Select', 'prime-english-classes'),
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
        'Libre Baskerville' => 'Libre Baskerville',
    );

    // Heading Font Setting
    $wp_customize->add_setting('prime_english_classes_heading_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'prime_english_classes_sanitize_choicess',
    ));
    $wp_customize->add_control('prime_english_classes_heading_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Heading', 'prime-english-classes'),
        'section' => 'prime_english_classes_typography_settings',
    ));

    // Body Font Setting
    $wp_customize->add_setting('prime_english_classes_body_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'prime_english_classes_sanitize_choicess',
    ));
    $wp_customize->add_control('prime_english_classes_body_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Body', 'prime-english-classes'),
        'section' => 'prime_english_classes_typography_settings',
    ));

    /** Typography Settings Section End */

    /** General Settings */
    $wp_customize->add_section(
        'prime_english_classes_general_settings',
        array(
            'title' => esc_html__( 'General Settings', 'prime-english-classes' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
        )
    );

    /** Scroll to top control */
    $wp_customize->add_setting( 
        'prime_english_classes_footer_scroll_to_top', 
        array(
            'default' => 1,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_footer_scroll_to_top',
        array(
            'label'       => __( 'Show Scroll To Top', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_general_settings',
            'type'        => 'checkbox',
        )
    );

     $wp_customize->add_setting('prime_english_classes_scroll_icon',array(
        'default'   => 'fas fa-arrow-up',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Prime_English_Classes_Changeable_Icon(
        $wp_customize,'prime_english_classes_scroll_icon',array(
        'label' => __('Scroll Top Icon','prime-english-classes'),
        'transport' => 'refresh',
        'section'   => 'prime_english_classes_general_settings',
        'type'      => 'icon'
    )));

    /** Preloader control */
    $wp_customize->add_setting( 
        'prime_english_classes_header_preloader', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_header_preloader',
        array(
            'label'       => __( 'Show Preloader', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_general_settings',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('prime_english_classes_loader_layout_setting', array(
        'default' => 'load',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    // Add control for loader layout
    $wp_customize->add_control('prime_english_classes_loader_layout_control', array(
        'label' => __('Preloader Layout', 'prime-english-classes'),
        'section' => 'prime_english_classes_general_settings',
        'settings' => 'prime_english_classes_loader_layout_setting',
        'type' => 'select',
        'choices' => array(
            'load' => __('Preloader 1', 'prime-english-classes'),
            'load-one' => __('Preloader 2', 'prime-english-classes'),
            'ctn-preloader' => __('Preloader 3', 'prime-english-classes'),
        ),
    ));

    // Add Setting for Menu Font Weight
    $wp_customize->add_setting( 'prime_english_classes_menu_font_weight', array(
        'default'           => '500',
        'sanitize_callback' => 'prime_english_classes_sanitize_font_weight',
    ) );

    // Add Control for Menu Font Weight
    $wp_customize->add_control( 'prime_english_classes_menu_font_weight', array(
        'label'    => __( 'Menu Font Weight', 'prime-english-classes' ),
        'section'  => 'prime_english_classes_general_settings',
        'type'     => 'select',
        'choices'  => array(
            '100' => __( '100 - Thin', 'prime-english-classes' ),
            '200' => __( '200 - Extra Light', 'prime-english-classes' ),
            '300' => __( '300 - Light', 'prime-english-classes' ),
            '400' => __( '400 - Normal', 'prime-english-classes' ),
            '500' => __( '500 - Medium', 'prime-english-classes' ),
            '600' => __( '600 - Semi Bold', 'prime-english-classes' ),
            '700' => __( '700 - Bold', 'prime-english-classes' ),
            '800' => __( '800 - Extra Bold', 'prime-english-classes' ),
            '900' => __( '900 - Black', 'prime-english-classes' ),
        ),
    ) );

    // Add Setting for Menu Text Transform
    $wp_customize->add_setting( 'prime_english_classes_menu_text_transform', array(
        'default'           => 'Capitalize',
        'sanitize_callback' => 'prime_english_classes_sanitize_text_transform',
    ) );

    // Add Control for Menu Text Transform
    $wp_customize->add_control( 'prime_english_classes_menu_text_transform', array(
        'label'    => __( 'Menu Text Transform', 'prime-english-classes' ),
        'section'  => 'prime_english_classes_general_settings',
        'type'     => 'select',
        'choices'  => array(
            'none'       => __( 'None', 'prime-english-classes' ),
            'capitalize' => __( 'Capitalize', 'prime-english-classes' ),
            'uppercase'  => __( 'Uppercase', 'prime-english-classes' ),
            'lowercase'  => __( 'Lowercase', 'prime-english-classes' ),
        ),
    ) );

    $wp_customize->add_setting('prime_english_classes_sidebar_text_align', array(
    'default'           => 'left',
    'sanitize_callback' => 'sanitize_text_field',
    ));

    // Add Sidebar Text Align Control
    $wp_customize->add_control('sidebar_text_align_control', array(
        'label'    => __('Sidebar Heading Text Align', 'prime-english-classes'),
        'section'  => 'prime_english_classes_general_settings',
        'settings' => 'prime_english_classes_sidebar_text_align',
        'type'     => 'select',
        'choices'  => array(
            'left'   => __('Left', 'prime-english-classes'),
            'center' => __('Center', 'prime-english-classes'),
        ),
    ));

    /** Header Section Settings */
    $wp_customize->add_section(
        'prime_english_classes_header_section_settings',
        array(
            'title' => esc_html__( 'Header Section Settings', 'prime-english-classes' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
        )
    );

     /** Email */
    $wp_customize->add_setting(
        'prime_english_classes_header_email',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_english_classes_header_email',
        array(
            'label' => esc_html__( 'Add Mail Address', 'prime-english-classes' ),
            'section' => 'prime_english_classes_header_section_settings',
            'type' => 'text',
        )
    );

      /** Phone */
    $wp_customize->add_setting(
        'prime_english_classes_header_phone',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_english_classes_header_phone',
        array(
            'label' => esc_html__( 'Add Phone', 'prime-english-classes' ),
            'section' => 'prime_english_classes_header_section_settings',
            'type' => 'text',
        )
    );

    /** Appointment Button */
    $wp_customize->add_setting(
        'prime_english_classes_header_btn_text',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_english_classes_header_btn_text',
        array(
            'label' => esc_html__( 'Add Button Text', 'prime-english-classes' ),
            'section' => 'prime_english_classes_header_section_settings',
            'type' => 'text',
        )
    );

    /** Appointment Button */
    $wp_customize->add_setting(
        'prime_english_classes_header_btn_url',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_english_classes_header_btn_url',
        array(
            'label' => esc_html__( 'Add Button URL', 'prime-english-classes' ),
            'section' => 'prime_english_classes_header_section_settings',
            'type' => 'url',
        )
    );


    $wp_customize->add_setting( 
        'prime_english_classes_show_hide_search', 
        array(
            'default' => false ,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_show_hide_search',
        array(
            'label'       => __( 'Show Search Icon', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_header_section_settings',
            'type'        => 'checkbox',
        )
    );
    $wp_customize->add_setting('prime_english_classes_search_icon',array(
        'default'   => 'fas fa-search',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Prime_English_Classes_Changeable_Icon(
        $wp_customize,'prime_english_classes_search_icon',array(
        'label' => __('Search Icon','prime-english-classes'),
        'transport' => 'refresh',
        'section'   => 'prime_english_classes_header_section_settings',
        'type'      => 'icon'
    )));

    /** Socail Section Settings */
    $wp_customize->add_section(
        'prime_english_classes_social_section_settings',
        array(
            'title' => esc_html__( 'Social Media Section Settings', 'prime-english-classes' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
        )
    );

    /** Socail Section control */
    $wp_customize->add_setting( 
        'prime_english_classes_social_icon_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_social_icon_setting',
        array(
            'label'       => __( 'Show Social Icon', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_social_section_settings',
            'type'        => 'checkbox',
        )
    );

    /**  Social Link 1 */
    $wp_customize->add_setting(
        'prime_english_classes_social_link_1',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_english_classes_social_link_1',
        array(
            'label' => esc_html__( 'Add Facebook Link', 'prime-english-classes' ),
            'section' => 'prime_english_classes_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 2 */
    $wp_customize->add_setting(
        'prime_english_classes_social_link_2',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_english_classes_social_link_2',
        array(
            'label' => esc_html__( 'Add Twitter Link', 'prime-english-classes' ),
            'section' => 'prime_english_classes_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 3 */
    $wp_customize->add_setting(
        'prime_english_classes_social_link_3',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_english_classes_social_link_3',
        array(
            'label' => esc_html__( 'Add Instagram Link', 'prime-english-classes' ),
            'section' => 'prime_english_classes_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 4 */
    $wp_customize->add_setting(
        'prime_english_classes_social_link_4',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_english_classes_social_link_4',
        array(
            'label' => esc_html__( 'Add Pintrest Link', 'prime-english-classes' ),
            'section' => 'prime_english_classes_social_section_settings',
            'type' => 'url',
        )
    );

    /** Socail Section Settings End */


    /** Home Page Settings */
    $wp_customize->add_panel( 
        'prime_english_classes_home_page_settings',
         array(
            'priority' => 40,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Home Page Settings', 'prime-english-classes' ),
            'description' => esc_html__( 'Customize Home Page Settings', 'prime-english-classes' ),
        ) 
    );

    /** Slider Section Settings */
    $wp_customize->add_section(
        'prime_english_classes_slider_section_settings',
        array(
            'title' => esc_html__( 'Slider Section Settings', 'prime-english-classes' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_english_classes_home_page_settings',
        )
    );

    /** Slider Section control */
    $wp_customize->add_setting( 
        'prime_english_classes_slider_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_slider_setting',
        array(
            'label'       => __( 'Show Slider', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_slider_section_settings',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('prime_english_classes_slider_background_image',
        array(
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control( $wp_customize,'prime_english_classes_slider_background_image',
            array(
                'label' => __('Slider Background Image','prime-english-classes'),
                'section' => 'prime_english_classes_slider_section_settings',
                'settings' => 'prime_english_classes_slider_background_image',
            )
        )
    );
    
    $categories = get_categories();
        $cat_posts = array();
            $i = 0;
            $cat_posts[]='Select';
        foreach($categories as $category){
            if($i==0){
            $default = $category->slug;
            $i++;
        }
        $cat_posts[$category->slug] = $category->name;
    }

    $wp_customize->add_setting(
        'prime_english_classes_blog_slide_category',
        array(
            'default'   => 'select',
            'sanitize_callback' => 'prime_english_classes_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'prime_english_classes_blog_slide_category',
        array(
            'type'    => 'select',
            'choices' => $cat_posts,
            'label' => __('Select Category to display Slides','prime-english-classes'),
            'section' => 'prime_english_classes_slider_section_settings',
        )
    );

    // Section Text
    $wp_customize->add_setting('prime_english_classes_slider_text_extra', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('prime_english_classes_slider_text_extra', 
        array(
        'label'       => __('Slider Extra Title', 'prime-english-classes'),
        'section'     => 'prime_english_classes_slider_section_settings',   
        'settings'    => 'prime_english_classes_slider_text_extra',
        'type'        => 'text'
        )
    );

    /** About Section Settings */
    
    $wp_customize->add_section( 'prime_english_classes_section_featured_about',
        array(
        'title'      => __( 'About Us Section', 'prime-english-classes' ),
        'priority'   => 110,
        'capability' => 'edit_theme_options',
        'panel' => 'prime_english_classes_home_page_settings',
        )
    );

    /** About Section control */
    $wp_customize->add_setting( 
        'prime_english_classes_about_setting', 
        array(
            'default'           => false,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_about_setting',
        array(
            'label'       => __( 'Show / Hide About', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_section_featured_about',
            'type'        => 'checkbox',
        )
    );

     // Section Sub Title
    $wp_customize->add_setting('prime_english_classes_about_text_extra', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('prime_english_classes_about_text_extra', 
        array(
        'label'       => __('About Us Extra Title', 'prime-english-classes'),
        'section'     => 'prime_english_classes_section_featured_about',   
        'settings'    => 'prime_english_classes_about_text_extra',
        'type'        => 'text'
        )
    );

    // Section Title
    $wp_customize->add_setting('prime_english_classes_featured_mission_section_title', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('prime_english_classes_featured_mission_section_title', 
        array(
        'label'       => __('Section Title', 'prime-english-classes'),
        'section'     => 'prime_english_classes_section_featured_about',   
        'settings'    => 'prime_english_classes_featured_mission_section_title',
        'type'        => 'text'
        )
    );

    $wp_customize->add_setting('prime_english_classes_about_points',array(
        'default'   => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('prime_english_classes_about_points',array(
        'label' => __('Add number of points','prime-english-classes'),
        'section'   => 'prime_english_classes_section_featured_about',
        'type'      => 'number',
        'input_attrs' => array(
        'min' => 1,     
        'max' => 3
        )
    ));
    $prime_english_classes_about_point = get_theme_mod('prime_english_classes_about_points','');
    for ( $m = 1; $m <= $prime_english_classes_about_point; $m++ ){

        $wp_customize->add_setting('prime_english_classes_about_points_text'.$m,array(
            'default'   => '',
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control('prime_english_classes_about_points_text'.$m,array(
            'label' => __('Add Text ','prime-english-classes').$m,
            'section'   => 'prime_english_classes_section_featured_about',
            'type'      => 'text'
        ));
        }

    // Post
    $wp_customize->add_setting('prime_english_classes_featured_mission_post_', 
        array(
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'prime_english_classes_dropdown_pages'
        )
    );

    $wp_customize->add_control('prime_english_classes_featured_mission_post_', 
        array(
        'label'       => __('Pages Dropdown', 'prime-english-classes'),
        'section'     => 'prime_english_classes_section_featured_about',   
        'settings'    => 'prime_english_classes_featured_mission_post_',
        'type'        => 'dropdown-pages',
        )
    );

    // Add About US static IMG 1
    $wp_customize->add_setting( 'prime_english_classes_about_us_img_1', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );


    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_english_classes_about_us_img_1', array(
        'label'    => __( 'Upload Image 1', 'prime-english-classes' ),
        'section'  => 'prime_english_classes_section_featured_about',
        'settings' => 'prime_english_classes_about_us_img_1',
        'button_labels' => array(
            'select'       => __( 'Select Image', 'prime-english-classes' ),
            'change'       => __( 'Change Image', 'prime-english-classes' ),
            'remove'       => __( 'Remove', 'prime-english-classes' ),
            'default'      => __( 'Default', 'prime-english-classes' ),
            'placeholder'  => __( 'No image selected', 'prime-english-classes' ),
        ),
    ) ) );

     // Add About US static IMG 1
    $wp_customize->add_setting( 'prime_english_classes_about_us_img_2', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );


    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_english_classes_about_us_img_2', array(
        'label'    => __( 'Upload Image 2', 'prime-english-classes' ),
        'section'  => 'prime_english_classes_section_featured_about',
        'settings' => 'prime_english_classes_about_us_img_2',
        'button_labels' => array(
            'select'       => __( 'Select Image', 'prime-english-classes' ),
            'change'       => __( 'Change Image', 'prime-english-classes' ),
            'remove'       => __( 'Remove', 'prime-english-classes' ),
            'default'      => __( 'Default', 'prime-english-classes' ),
            'placeholder'  => __( 'No image selected', 'prime-english-classes' ),
        ),
    ) ) );
    
    
    /** Home Page Settings Ends */
    
    /** Footer Section */
    $wp_customize->add_section(
        'prime_english_classes_footer_section',
        array(
            'title' => __( 'Footer Settings', 'prime-english-classes' ),
            'priority' => 70,
        )
    );

    /** Footer Copyright control */
    $wp_customize->add_setting( 
        'prime_english_classes_footer_setting', 
        array(
            'default' => true,
            'sanitize_callback' => 'prime_english_classes_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_english_classes_footer_setting',
        array(
            'label'       => __( 'Show Footer Copyright', 'prime-english-classes' ),
            'section'     => 'prime_english_classes_footer_section',
            'type'        => 'checkbox',
        )
    );
    
    /** Copyright Text */
    $wp_customize->add_setting(
        'prime_english_classes_footer_copyright_text',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'prime_english_classes_footer_copyright_text',
        array(
            'label' => __( 'Copyright Info', 'prime-english-classes' ),
            'section' => 'prime_english_classes_footer_section',
            'type' => 'text',
        )
    );  
    $wp_customize->add_setting('prime_english_classes_footer_background_image',
            array(
            'default' => '',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'absint',
            )
        );


    $wp_customize->add_control(
         new WP_Customize_Cropped_Image_Control($wp_customize, 'prime_english_classes_footer_background_image',
            array(
                'label' => esc_html__('Footer Background Image', 'prime-english-classes'),
                'description' => sprintf(esc_html__('Recommended Size %1$s px X %2$s px', 'prime-english-classes'), 1024, 800),
                'section' => 'prime_english_classes_footer_section',
                'width' => 1024,
                'height' => 800,
                'flex_width' => true,
                'flex_height' => true,
                'priority' => 100,
            )
        )
    );

    /* Footer Background Color*/
    $wp_customize->add_setting(
        'prime_english_classes_footer_background_color',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'prime_english_classes_footer_background_color',
            array(
                'label' => __('Footer Widget Area Background Color', 'prime-english-classes'),
                'section' => 'prime_english_classes_footer_section',
                'type' => 'color',
            )
        )
    );

    // 404 PAGE SETTINGS
    $wp_customize->add_section(
        'prime_english_classes_404_section',
        array(
            'title' => __( '404 Page Settings', 'prime-english-classes' ),
            'priority' => 70,
        )
    );
   
    $wp_customize->add_setting('404_page_image', array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw', // Sanitize as URL
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, '404_page_image', array(
        'label' => __('404 Page Image', 'prime-english-classes'),
        'section' => 'prime_english_classes_404_section',
        'settings' => '404_page_image',
    )));

    $wp_customize->add_setting('404_pagefirst_header', array(
        'default' => __('404', 'prime-english-classes'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_pagefirst_header', array(
        'type' => 'text',
        'label' => __('Heading', 'prime-english-classes'),
        'section' => 'prime_english_classes_404_section',
    ));

    // Setting for 404 page header
    $wp_customize->add_setting('404_page_header', array(
        'default' => __('Sorry, that page can\'t be found!', 'prime-english-classes'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_page_header', array(
        'type' => 'text',
        'label' => __('Heading', 'prime-english-classes'),
        'section' => 'prime_english_classes_404_section',
    ));
    function prime_english_classes_sanitize_choices( $input, $setting ) {
        global $wp_customize; 
        $control = $wp_customize->get_control( $setting->id ); 
        if ( array_key_exists( $input, $control->choices ) ) {
            return $input;
        } else {
            return $setting->default;
        }
    }

    function prime_english_classes_sanitize_choicess($input) {
    $valid = array(
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
    );

    return (array_key_exists($input, $valid)) ? $input : '';
}

}
add_action( 'customize_register', 'prime_english_classes_customize_register' );
endif;

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function prime_english_classes_customize_preview_js() {
    // Use minified libraries if SCRIPT_DEBUG is false
    $prime_english_classes_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $prime_english_classes_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script( 'prime_english_classes_customizer', get_template_directory_uri() . '/js' . $prime_english_classes_build . '/customizer' . $prime_english_classes_suffix . '.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'prime_english_classes_customize_preview_js' );