<?php 
/**
 * Template part for displaying Featured Classes Section
 *
 * @package Prime Education Learning
 */

$prime_education_learning_about = get_theme_mod( 'prime_education_learning_about_setting',false );
$prime_education_learning_featured_mission_section_title = get_theme_mod( 'prime_education_learning_featured_mission_section_title' );
$prime_education_learning_featured_mission_posts[] = get_theme_mod( 'prime_education_learning_featured_mission_post_' );

?>
<?php if ( $prime_education_learning_about ){?>
<div id="about-section" class="section-content py-5">
    <div class="container">        
        <?php $args = array (
            'post_type'     => 'page',
            'posts_per_page' => 1,
            'post__in'      => $prime_education_learning_featured_mission_posts,
            'orderby'       =>'post__in',
            'ignore_sticky_posts' => true,
        );?>
        <?php
        $loop = new WP_Query($args);
        if ( $loop->have_posts() ) :
            while ($loop->have_posts()) : $loop->the_post(); ?>
            <div class="featured-mission-box">
                <div class="row">
                    <div class="col-lg-4 col-md-6 align-self-center about-us">
                        <div class="about-img">
                           <?php
                              if ( has_post_thumbnail() ) :
                                the_post_thumbnail();
                              else:
                                ?>
                                <div class="image-container">
                                  <img src="<?php echo get_stylesheet_directory_uri() . '/images/default-header.png'; ?>">
                                </div>
                                <?php
                              endif;
                            ?>
                        </div>
                    </div>                    
                    <div class="col-lg-4 col-md-6 align-self-center side-1">
                        <div class="entry-header">
                            <?php if( !empty($prime_education_learning_featured_mission_section_title) ): ?>
                                <div class="section-title">
                                    <h3><?php echo esc_html($prime_education_learning_featured_mission_section_title); ?></h3>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="entry-content">
                            <p class="mb-0"><?php echo wp_trim_words( get_the_content(), 50 ); ?></p>
                        </div>

                        <div class="btn-green my-4">
                            <a href="<?php the_permalink(); ?>">
                            <i class="fa-solid fa-circle-info me-3"></i><?php esc_html_e('READ MORE','prime-education-learning'); ?>
                            </a>
                        </div>  
                    </div>
                    <div class="col-lg-4 col-md-12 side-2 align-self-center">
                        <?php if ( get_theme_mod('prime_education_learning_about_us_img_1') ) : ?>
                            <img src="<?php echo esc_url(get_theme_mod('prime_education_learning_about_us_img_1')); ?>">
                        <?php endif; ?>
                        <?php if ( get_theme_mod('prime_education_learning_about_us_img_2') ) : ?>
                            <img class="img-2" src="<?php echo esc_url(get_theme_mod('prime_education_learning_about_us_img_2')); ?>">
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
    </div>
</div>
<?php } ?>