<?php
/**
 * Banner Section
 * 
 * @package prime_education_learning
 */
$prime_education_learning_slider = get_theme_mod( 'prime_education_learning_slider_setting',false );
$prime_education_learning_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('prime_education_learning_blog_slide_category'),
  'posts_per_page' => 3,
); ?>

<?php if ( $prime_education_learning_slider ){?>
  <div class="banner">
    <div class="owl-carousel">
      <?php $prime_education_learning_arr_posts = new WP_Query( $prime_education_learning_args );
      if ( $prime_education_learning_arr_posts->have_posts() ) :
        while ( $prime_education_learning_arr_posts->have_posts() ) :
          $prime_education_learning_arr_posts->the_post();
          ?>
          <div class="banner_inner_box">
            <?php
              if ( has_post_thumbnail() ) :
                the_post_thumbnail();
              else:
                ?>
                <div class="banner_inner_box">
                  <img src="<?php echo get_stylesheet_directory_uri() . '/images/slide.png'; ?>">
                </div>
                <?php
              endif;
            ?>
            <div class="banner_box">
              <?php if ( get_theme_mod('prime_education_learning_slider_text_extra') ) : ?>
                <h5><?php echo esc_html(get_theme_mod('prime_education_learning_slider_text_extra'));?></h5>
              <?php endif; ?>
              <h3 class="my-3"><?php the_title(); ?></a></h3>
               <p class="mb-0 slide-para"><?php echo wp_trim_words( get_the_content(), 30 ); ?></p>
              <div class="slide-btns">
                <p class="btn-green mt-4">
                <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><i class="fa-solid fa-rocket"></i><?php esc_html_e('REQUEST QUOTE','prime-education-learning'); ?></a>
              </p>
              <?php if ( get_theme_mod('prime_education_learning_slider_second_button_url') ) : ?>
                  <p class="btn-green BTN-2">
                    <a target="_blank" href="<?php echo esc_url(get_theme_mod('prime_education_learning_slider_second_button_url'));?>"><i class="fa-solid fa-rocket"></i><?php esc_html_e('CONTACT US','prime-education-learning'); ?></a>
                  </p>
                <?php endif; ?> 
              </div>
            </div>
          </div>
        <?php
      endwhile;
      wp_reset_postdata();
      endif; ?>
    </div>
  </div>
<?php } ?>