<?php
/**
 * Prime Education Learning Theme Customizer.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package prime_education_learning
 */

if( ! function_exists( 'prime_education_learning_customize_register' ) ):  
/**
 * Add postMessage support for site title and description for the Theme Customizer.F
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function prime_education_learning_customize_register( $wp_customize ) {
    require get_parent_theme_file_path('/inc/controls/changeable-icon.php');
    

    if ( version_compare( get_bloginfo('version'),'4.9', '>=') ) {
        $wp_customize->get_section( 'static_front_page' )->title = __( 'Static Front Page', 'prime-education-learning' );
    }
	
    /* Option list of all post */	
    $prime_education_learning_options_posts = array();
    $prime_education_learning_options_posts_obj = get_posts('posts_per_page=-1');
    $prime_education_learning_options_posts[''] = esc_html__( 'Choose Post', 'prime-education-learning' );
    foreach ( $prime_education_learning_options_posts_obj as $prime_education_learning_posts ) {
    	$prime_education_learning_options_posts[$prime_education_learning_posts->ID] = $prime_education_learning_posts->post_title;
    }
    
    /* Option list of all categories */
    $prime_education_learning_args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'order'                    => 'ASC',
	   'hide_empty'               => 1,
	   'hierarchical'             => 1,
	   'taxonomy'                 => 'category'
    ); 
    $prime_education_learning_option_categories = array();
    $prime_education_learning_category_lists = get_categories( $prime_education_learning_args );
    $prime_education_learning_option_categories[''] = esc_html__( 'Choose Category', 'prime-education-learning' );
    foreach( $prime_education_learning_category_lists as $prime_education_learning_category ){
        $prime_education_learning_option_categories[$prime_education_learning_category->term_id] = $prime_education_learning_category->name;
    }
    
    /** Default Settings */    
    $wp_customize->add_panel( 
        'wp_default_panel',
         array(
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__( 'Default Settings', 'prime-education-learning' ),
            'description' => esc_html__( 'Default section provided by wordpress customizer.', 'prime-education-learning' ),
        ) 
    );
    
    $wp_customize->get_section( 'title_tagline' )->panel                  = 'wp_default_panel';
    $wp_customize->get_section( 'colors' )->panel                         = 'wp_default_panel';
    $wp_customize->get_section( 'header_image' )->panel                   = 'wp_default_panel';
    $wp_customize->get_section( 'background_image' )->panel               = 'wp_default_panel';
    $wp_customize->get_section( 'static_front_page' )->panel              = 'wp_default_panel';
    
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    
    /** Default Settings Ends */
    
    /** Site Title control */
    $wp_customize->add_setting( 
        'header_site_title', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_site_title',
        array(
            'label'       => __( 'Show / Hide Site Title', 'prime-education-learning' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    /** Tagline control */
    $wp_customize->add_setting( 
        'header_tagline', 
        array(
            'default'           => false,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_tagline',
        array(
            'label'       => __( 'Show / Hide Tagline', 'prime-education-learning' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('logo_width', array(
        'sanitize_callback' => 'absint', 
    ));

    // Add a control for logo width
    $wp_customize->add_control('logo_width', array(
        'label' => __('Logo Width', 'prime-education-learning'),
        'section' => 'title_tagline',
        'type' => 'number',
        'input_attrs' => array(
            'min' => '50', 
            'max' => '500', 
            'step' => '5', 
    ),
        'default' => '100', 
    ));

    $wp_customize->add_setting( 'prime_education_learning_site_title_size', array(
        'default'           => 30, // Default font size in pixels
        'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
    ) );

    // Add control for site title size
    $wp_customize->add_control( 'prime_education_learning_site_title_size', array(
        'type'        => 'number',
        'section'     => 'title_tagline', // You can change this section to your preferred section
        'label'       => __( 'Site Title Font Size (px)', 'prime-education-learning' ),
        'input_attrs' => array(
            'min'  => 10,
            'max'  => 100,
            'step' => 1,
        ),
    ) );
    /** Post Settings */
    $wp_customize->add_section(
        'prime_education_learning_post_settings',
        array(
            'title' => esc_html__( 'Post Settings', 'prime-education-learning' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
        )
    );

    /** Post Heading control */
    $wp_customize->add_setting( 
        'prime_education_learning_post_heading_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_post_heading_setting',
        array(
            'label'       => __( 'Show / Hide Post Heading', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Meta control */
    $wp_customize->add_setting( 
        'prime_education_learning_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Post Meta', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Image control */
    $wp_customize->add_setting( 
        'prime_education_learning_post_image_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_post_image_setting',
        array(
            'label'       => __( 'Show / Hide Post Image', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Content control */
    $wp_customize->add_setting( 
        'prime_education_learning_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Post Content', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_post_settings',
            'type'        => 'checkbox',
        )
    );
    /** Post ReadMore control */
     $wp_customize->add_setting( 'prime_education_learning_read_more_setting`', array(
        'default'           => true,
        'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
    ) );

    $wp_customize->add_control( 'prime_education_learning_read_more_setting`', array(
        'type'        => 'checkbox',
        'section'     => 'prime_education_learning_post_settings', 
        'label'       => __( 'Display Read More Button', 'prime-education-learning' ),
    ) );

    /** Post Settings Ends */

     /** Single Post Settings */
    $wp_customize->add_section(
        'prime_education_learning_single_post_settings',
        array(
            'title' => esc_html__( 'Single Post Settings', 'prime-education-learning' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
        )
    );

    /** Single Post Meta control */
    $wp_customize->add_setting( 
        'prime_education_learning_single_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_single_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Meta', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Content control */
    $wp_customize->add_setting( 
        'prime_education_learning_single_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_single_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Content', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Settings Ends */

         // Typography Settings Section
    $wp_customize->add_section('prime_education_learning_typography_settings', array(
        'title'      => esc_html__('Typography Settings', 'prime-education-learning'),
        'priority'   => 30,
        'capability' => 'edit_theme_options',
    ));

    // Array of fonts to choose from
    $font_choices = array(
        ''               => __('Select', 'prime-education-learning'),
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
        'Libre Baskerville' => 'Libre Baskerville',
    );

    // Heading Font Setting
    $wp_customize->add_setting('prime_education_learning_heading_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'prime_education_learning_sanitize_choicess',
    ));
    $wp_customize->add_control('prime_education_learning_heading_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Heading', 'prime-education-learning'),
        'section' => 'prime_education_learning_typography_settings',
    ));

    // Body Font Setting
    $wp_customize->add_setting('prime_education_learning_body_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'prime_education_learning_sanitize_choicess',
    ));
    $wp_customize->add_control('prime_education_learning_body_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Body', 'prime-education-learning'),
        'section' => 'prime_education_learning_typography_settings',
    ));

    /** Typography Settings Section End */

    /** General Settings */
    $wp_customize->add_section(
        'prime_education_learning_general_settings',
        array(
            'title' => esc_html__( 'General Settings', 'prime-education-learning' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
        )
    );

    /** Scroll to top control */
    $wp_customize->add_setting( 
        'prime_education_learning_footer_scroll_to_top', 
        array(
            'default' => 1,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_footer_scroll_to_top',
        array(
            'label'       => __( 'Show Scroll To Top', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_general_settings',
            'type'        => 'checkbox',
        )
    );

     $wp_customize->add_setting('prime_education_learning_scroll_icon',array(
        'default'   => 'fas fa-arrow-up',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Prime_Education_Learning_Changeable_Icon(
        $wp_customize,'prime_education_learning_scroll_icon',array(
        'label' => __('Scroll Top Icon','prime-education-learning'),
        'transport' => 'refresh',
        'section'   => 'prime_education_learning_general_settings',
        'type'      => 'icon'
    )));

    /** Preloader control */
    $wp_customize->add_setting( 
        'prime_education_learning_header_preloader', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_header_preloader',
        array(
            'label'       => __( 'Show Preloader', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_general_settings',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('prime_education_learning_loader_layout_setting', array(
        'default' => 'load',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    // Add control for loader layout
    $wp_customize->add_control('prime_education_learning_loader_layout_control', array(
        'label' => __('Preloader Layout', 'prime-education-learning'),
        'section' => 'prime_education_learning_general_settings',
        'settings' => 'prime_education_learning_loader_layout_setting',
        'type' => 'select',
        'choices' => array(
            'load' => __('Preloader 1', 'prime-education-learning'),
            'load-one' => __('Preloader 2', 'prime-education-learning'),
            'ctn-preloader' => __('Preloader 3', 'prime-education-learning'),
        ),
    ));
    /** Sticky Header control */
    $wp_customize->add_setting( 
        'prime_education_learning_sticky_header', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_sticky_header',
        array(
            'label'       => __( 'Show Sticky Header', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_general_settings',
            'type'        => 'checkbox',
        )
    );

    // Add Setting for Menu Font Weight
    $wp_customize->add_setting( 'prime_education_learning_menu_font_weight', array(
        'default'           => 'Bold',
        'sanitize_callback' => 'prime_education_learning_sanitize_font_weight',
    ) );

    // Add Control for Menu Font Weight
    $wp_customize->add_control( 'prime_education_learning_menu_font_weight', array(
        'label'    => __( 'Menu Font Weight', 'prime-education-learning' ),
        'section'  => 'prime_education_learning_general_settings',
        'type'     => 'select',
        'choices'  => array(
            '100' => __( '100 - Thin', 'prime-education-learning' ),
            '200' => __( '200 - Extra Light', 'prime-education-learning' ),
            '300' => __( '300 - Light', 'prime-education-learning' ),
            '400' => __( '400 - Normal', 'prime-education-learning' ),
            '500' => __( '500 - Medium', 'prime-education-learning' ),
            '600' => __( '600 - Semi Bold', 'prime-education-learning' ),
            '700' => __( '700 - Bold', 'prime-education-learning' ),
            '800' => __( '800 - Extra Bold', 'prime-education-learning' ),
            '900' => __( '900 - Black', 'prime-education-learning' ),
        ),
    ) );

    // Add Setting for Menu Text Transform
    $wp_customize->add_setting( 'prime_education_learning_menu_text_transform', array(
        'default'           => 'Capitalize',
        'sanitize_callback' => 'prime_education_learning_sanitize_text_transform',
    ) );

    // Add Control for Menu Text Transform
    $wp_customize->add_control( 'prime_education_learning_menu_text_transform', array(
        'label'    => __( 'Menu Text Transform', 'prime-education-learning' ),
        'section'  => 'prime_education_learning_general_settings',
        'type'     => 'select',
        'choices'  => array(
            'none'       => __( 'None', 'prime-education-learning' ),
            'capitalize' => __( 'Capitalize', 'prime-education-learning' ),
            'uppercase'  => __( 'Uppercase', 'prime-education-learning' ),
            'lowercase'  => __( 'Lowercase', 'prime-education-learning' ),
        ),
    ) );

    $wp_customize->add_setting('prime_education_learning_sidebar_text_align', array(
    'default'           => 'left',
    'sanitize_callback' => 'sanitize_text_field',
    ));

    // Add Sidebar Text Align Control
    $wp_customize->add_control('sidebar_text_align_control', array(
        'label'    => __('Sidebar Heading Text Align', 'prime-education-learning'),
        'section'  => 'prime_education_learning_general_settings',
        'settings' => 'prime_education_learning_sidebar_text_align',
        'type'     => 'select',
        'choices'  => array(
            'left'   => __('Left', 'prime-education-learning'),
            'center' => __('Center', 'prime-education-learning'),
        ),
    ));

    /** Header Section Settings */
    $wp_customize->add_section(
        'prime_education_learning_header_section_settings',
        array(
            'title' => esc_html__( 'Header Section Settings', 'prime-education-learning' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
        )
    );

     /** Topbar Text */
    $wp_customize->add_setting(
        'prime_education_learning_header_location',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_education_learning_header_location',
        array(
            'label' => esc_html__( 'Add Topbar Text', 'prime-education-learning' ),
            'section' => 'prime_education_learning_header_section_settings',
            'type' => 'text',
        )
    );

    /** Address */
    $wp_customize->add_setting(
        'prime_education_learning_address',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_education_learning_address',
        array(
            'label' => esc_html__( 'Add Address', 'prime-education-learning' ),
            'section' => 'prime_education_learning_header_section_settings',
            'type' => 'text',
        )
    );

     /** Email */
    $wp_customize->add_setting(
        'prime_education_learning_header_email',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_education_learning_header_email',
        array(
            'label' => esc_html__( 'Add Mail Address', 'prime-education-learning' ),
            'section' => 'prime_education_learning_header_section_settings',
            'type' => 'text',
        )
    );

      /** Phone */
    $wp_customize->add_setting(
        'prime_education_learning_header_phone',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_education_learning_header_phone',
        array(
            'label' => esc_html__( 'Add Phone', 'prime-education-learning' ),
            'section' => 'prime_education_learning_header_section_settings',
            'type' => 'text',
        )
    );
    $wp_customize->add_setting('prime_education_learning_phone_icon',array(
        'default'   => 'fas fa-phone-volume',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Prime_Education_Learning_Changeable_Icon(
        $wp_customize,'prime_education_learning_phone_icon',array(
        'label' => __('Phone Icon','prime-education-learning'),
        'transport' => 'refresh',
        'section'   => 'prime_education_learning_header_section_settings',
        'type'      => 'icon'
    )));

        /** Appointment Button */
    $wp_customize->add_setting(
        'prime_education_learning_header_btn_text',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_education_learning_header_btn_text',
        array(
            'label' => esc_html__( 'Add Button Text', 'prime-education-learning' ),
            'section' => 'prime_education_learning_header_section_settings',
            'type' => 'text',
        )
    );

    /** Appointment Button */
    $wp_customize->add_setting(
        'prime_education_learning_header_btn_url',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_education_learning_header_btn_url',
        array(
            'label' => esc_html__( 'Add Button URL', 'prime-education-learning' ),
            'section' => 'prime_education_learning_header_section_settings',
            'type' => 'url',
        )
    );


    $wp_customize->add_setting( 
        'prime_education_learning_show_hide_search', 
        array(
            'default' => false ,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_show_hide_search',
        array(
            'label'       => __( 'Show Search Icon', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_header_section_settings',
            'type'        => 'checkbox',
        )
    );
    $wp_customize->add_setting('prime_education_learning_search_icon',array(
        'default'   => 'fas fa-search',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Prime_Education_Learning_Changeable_Icon(
        $wp_customize,'prime_education_learning_search_icon',array(
        'label' => __('Search Icon','prime-education-learning'),
        'transport' => 'refresh',
        'section'   => 'prime_education_learning_header_section_settings',
        'type'      => 'icon'
    )));

    /** Socail Section Settings */
    $wp_customize->add_section(
        'prime_education_learning_social_section_settings',
        array(
            'title' => esc_html__( 'Social Media Section Settings', 'prime-education-learning' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
        )
    );

    /** Socail Section control */
    $wp_customize->add_setting( 
        'prime_education_learning_social_icon_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_social_icon_setting',
        array(
            'label'       => __( 'Show Social Icon', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_social_section_settings',
            'type'        => 'checkbox',
        )
    );

    /**  Social Link 1 */
    $wp_customize->add_setting(
        'prime_education_learning_social_link_1',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_education_learning_social_link_1',
        array(
            'label' => esc_html__( 'Add Facebook Link', 'prime-education-learning' ),
            'section' => 'prime_education_learning_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 2 */
    $wp_customize->add_setting(
        'prime_education_learning_social_link_2',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_education_learning_social_link_2',
        array(
            'label' => esc_html__( 'Add Twitter Link', 'prime-education-learning' ),
            'section' => 'prime_education_learning_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 3 */
    $wp_customize->add_setting(
        'prime_education_learning_social_link_3',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_education_learning_social_link_3',
        array(
            'label' => esc_html__( 'Add Instagram Link', 'prime-education-learning' ),
            'section' => 'prime_education_learning_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 4 */
    $wp_customize->add_setting(
        'prime_education_learning_social_link_4',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_education_learning_social_link_4',
        array(
            'label' => esc_html__( 'Add Pintrest Link', 'prime-education-learning' ),
            'section' => 'prime_education_learning_social_section_settings',
            'type' => 'url',
        )
    );

    /** Socail Section Settings End */


    /** Home Page Settings */
    $wp_customize->add_panel( 
        'prime_education_learning_home_page_settings',
         array(
            'priority' => 40,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Home Page Settings', 'prime-education-learning' ),
            'description' => esc_html__( 'Customize Home Page Settings', 'prime-education-learning' ),
        ) 
    );

    /** Slider Section Settings */
    $wp_customize->add_section(
        'prime_education_learning_slider_section_settings',
        array(
            'title' => esc_html__( 'Slider Section Settings', 'prime-education-learning' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_education_learning_home_page_settings',
        )
    );

    /** Slider Section control */
    $wp_customize->add_setting( 
        'prime_education_learning_slider_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_slider_setting',
        array(
            'label'       => __( 'Show Slider', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_slider_section_settings',
            'type'        => 'checkbox',
        )
    );
    
    $categories = get_categories();
        $cat_posts = array();
            $i = 0;
            $cat_posts[]='Select';
        foreach($categories as $category){
            if($i==0){
            $default = $category->slug;
            $i++;
        }
        $cat_posts[$category->slug] = $category->name;
    }

    $wp_customize->add_setting(
        'prime_education_learning_blog_slide_category',
        array(
            'default'   => 'select',
            'sanitize_callback' => 'prime_education_learning_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'prime_education_learning_blog_slide_category',
        array(
            'type'    => 'select',
            'choices' => $cat_posts,
            'label' => __('Select Category to display Slides','prime-education-learning'),
            'section' => 'prime_education_learning_slider_section_settings',
        )
    );

    // Section Text
    $wp_customize->add_setting('prime_education_learning_slider_text_extra', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('prime_education_learning_slider_text_extra', 
        array(
        'label'       => __('Slider Extra Title', 'prime-education-learning'),
        'section'     => 'prime_education_learning_slider_section_settings',   
        'settings'    => 'prime_education_learning_slider_text_extra',
        'type'        => 'text'
        )
    );

        // Section Text
    $wp_customize->add_setting('prime_education_learning_slider_second_button_url', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('prime_education_learning_slider_second_button_url', 
        array(
        'label'       => __('Slider Second Button URL', 'prime-education-learning'),
        'section'     => 'prime_education_learning_slider_section_settings',   
        'settings'    => 'prime_education_learning_slider_second_button_url',
        'type'        => 'url'
        )
    );


    
    /** About Section Settings */
    
    $wp_customize->add_section( 'prime_education_learning_section_featured_about',
        array(
        'title'      => __( 'About Us Section', 'prime-education-learning' ),
        'priority'   => 110,
        'capability' => 'edit_theme_options',
        'panel' => 'prime_education_learning_home_page_settings',
        )
    );

    /** About Section control */
    $wp_customize->add_setting( 
        'prime_education_learning_about_setting', 
        array(
            'default'           => false,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_about_setting',
        array(
            'label'       => __( 'Show / Hide About', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_section_featured_about',
            'type'        => 'checkbox',
        )
    );

    // Section Title
    $wp_customize->add_setting('prime_education_learning_featured_mission_section_title', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('prime_education_learning_featured_mission_section_title', 
        array(
        'label'       => __('Section Title', 'prime-education-learning'),
        'section'     => 'prime_education_learning_section_featured_about',   
        'settings'    => 'prime_education_learning_featured_mission_section_title',
        'type'        => 'text'
        )
    );

    // Post
    $wp_customize->add_setting('prime_education_learning_featured_mission_post_', 
        array(
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'prime_education_learning_dropdown_pages'
        )
    );

    $wp_customize->add_control('prime_education_learning_featured_mission_post_', 
        array(
        'label'       => __('Pages Dropdown', 'prime-education-learning'),
        'section'     => 'prime_education_learning_section_featured_about',   
        'settings'    => 'prime_education_learning_featured_mission_post_',
        'type'        => 'dropdown-pages',
        )
    );

    // Add About US static IMG 1
    $wp_customize->add_setting( 'prime_education_learning_about_us_img_1', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );


    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_education_learning_about_us_img_1', array(
        'label'    => __( 'Upload Image 1', 'prime-education-learning' ),
        'section'  => 'prime_education_learning_section_featured_about',
        'settings' => 'prime_education_learning_about_us_img_1',
        'button_labels' => array(
            'select'       => __( 'Select Image', 'prime-education-learning' ),
            'change'       => __( 'Change Image', 'prime-education-learning' ),
            'remove'       => __( 'Remove', 'prime-education-learning' ),
            'default'      => __( 'Default', 'prime-education-learning' ),
            'placeholder'  => __( 'No image selected', 'prime-education-learning' ),
        ),
    ) ) );

     // Add About US static IMG 1
    $wp_customize->add_setting( 'prime_education_learning_about_us_img_2', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );


    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_education_learning_about_us_img_2', array(
        'label'    => __( 'Upload Image 2', 'prime-education-learning' ),
        'section'  => 'prime_education_learning_section_featured_about',
        'settings' => 'prime_education_learning_about_us_img_2',
        'button_labels' => array(
            'select'       => __( 'Select Image', 'prime-education-learning' ),
            'change'       => __( 'Change Image', 'prime-education-learning' ),
            'remove'       => __( 'Remove', 'prime-education-learning' ),
            'default'      => __( 'Default', 'prime-education-learning' ),
            'placeholder'  => __( 'No image selected', 'prime-education-learning' ),
        ),
    ) ) );
    
    
    /** Home Page Settings Ends */
    
    /** Footer Section */
    $wp_customize->add_section(
        'prime_education_learning_footer_section',
        array(
            'title' => __( 'Footer Settings', 'prime-education-learning' ),
            'priority' => 70,
        )
    );

    /** Footer Copyright control */
    $wp_customize->add_setting( 
        'prime_education_learning_footer_setting', 
        array(
            'default' => true,
            'sanitize_callback' => 'prime_education_learning_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_education_learning_footer_setting',
        array(
            'label'       => __( 'Show Footer Copyright', 'prime-education-learning' ),
            'section'     => 'prime_education_learning_footer_section',
            'type'        => 'checkbox',
        )
    );
    
    /** Copyright Text */
    $wp_customize->add_setting(
        'prime_education_learning_footer_copyright_text',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'prime_education_learning_footer_copyright_text',
        array(
            'label' => __( 'Copyright Info', 'prime-education-learning' ),
            'section' => 'prime_education_learning_footer_section',
            'type' => 'text',
        )
    );  
$wp_customize->add_setting('prime_education_learning_footer_background_image',
        array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
        )
    );


    $wp_customize->add_control(
         new WP_Customize_Cropped_Image_Control($wp_customize, 'prime_education_learning_footer_background_image',
            array(
                'label' => esc_html__('Footer Background Image', 'prime-education-learning'),
                'description' => sprintf(esc_html__('Recommended Size %1$s px X %2$s px', 'prime-education-learning'), 1024, 800),
                'section' => 'prime_education_learning_footer_section',
                'width' => 1024,
                'height' => 800,
                'flex_width' => true,
                'flex_height' => true,
                'priority' => 100,
            )
        )
    );

    /* Footer Background Color*/
    $wp_customize->add_setting(
        'prime_education_learning_footer_background_color',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'prime_education_learning_footer_background_color',
            array(
                'label' => __('Footer Widget Area Background Color', 'prime-education-learning'),
                'section' => 'prime_education_learning_footer_section',
                'type' => 'color',
            )
        )
    );

    // 404 PAGE SETTINGS
    $wp_customize->add_section(
        'prime_education_learning_404_section',
        array(
            'title' => __( '404 Page Settings', 'prime-education-learning' ),
            'priority' => 70,
        )
    );
   
    $wp_customize->add_setting('404_page_image', array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw', // Sanitize as URL
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, '404_page_image', array(
        'label' => __('404 Page Image', 'prime-education-learning'),
        'section' => 'prime_education_learning_404_section',
        'settings' => '404_page_image',
    )));

    $wp_customize->add_setting('404_pagefirst_header', array(
        'default' => __('404', 'prime-education-learning'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_pagefirst_header', array(
        'type' => 'text',
        'label' => __('Heading', 'prime-education-learning'),
        'section' => 'prime_education_learning_404_section',
    ));

    // Setting for 404 page header
    $wp_customize->add_setting('404_page_header', array(
        'default' => __('Sorry, that page can\'t be found!', 'prime-education-learning'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_page_header', array(
        'type' => 'text',
        'label' => __('Heading', 'prime-education-learning'),
        'section' => 'prime_education_learning_404_section',
    ));
    function prime_education_learning_sanitize_choices( $input, $setting ) {
        global $wp_customize; 
        $control = $wp_customize->get_control( $setting->id ); 
        if ( array_key_exists( $input, $control->choices ) ) {
            return $input;
        } else {
            return $setting->default;
        }
    }

    function prime_education_learning_sanitize_choicess($input) {
    $valid = array(
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
    );

    return (array_key_exists($input, $valid)) ? $input : '';
}

}
add_action( 'customize_register', 'prime_education_learning_customize_register' );
endif;

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function prime_education_learning_customize_preview_js() {
    // Use minified libraries if SCRIPT_DEBUG is false
    $prime_education_learning_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $prime_education_learning_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script( 'prime_education_learning_customizer', get_template_directory_uri() . '/js' . $prime_education_learning_build . '/customizer' . $prime_education_learning_suffix . '.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'prime_education_learning_customize_preview_js' );